OPEN "COM2:9600,N,8,2,BIN,CD0,CS0,DS0,OP0,RB32767,TB512" FOR RANDOM AS #1
CLOSE #1
DEF SEG = &H40
LET COM2 = PEEK(3) * 256 + PEEK(2)
GOSUB ReadCOM2
GOSUB GetCOM2status
CLS
GOSUB PrintCOM2status
DO
  DO
    ch$ = INKEY$
  LOOP WHILE ch$ = ""
  SELECT CASE ch$
    CASE " "
      GOSUB GetCOM2status
      GOSUB PrintCOM2status
    CASE CHR$(13)
      GOSUB ReadCOM2
      GOSUB PrintCOM2status
  END SELECT
LOOP UNTIL ch$ = CHR$(27)

  END

REM ======================================================================
REM
REM
REM
REM ======================================================================

ReadCOM2:
  LET DI = INP(COM2)
  RETURN

REM ======================================================================
REM
REM
REM
REM ======================================================================

GetCOM2status:
  OUT COM2 + 3, INP(COM2 + 3) OR &H80
  LET F9sp = INP(COM2 + 1)
  LET F8sp = INP(COM2)
  OUT COM2 + 3, INP(COM2 + 3) AND &H7F
  LET IAK = INP(COM2 + 1)
  LET IRQ = INP(COM2 + 2)
  LET LCTR = INP(COM2 + 3)
  LET MCRT = INP(COM2 + 4)
  LET LSTS = INP(COM2 + 5)
  LET MSTS = INP(COM2 + 6)
  RETURN

REM ======================================================================
REM
REM
REM
REM ======================================================================

PrintCOM2status:
  REM   0         1         2         3         4         5         6         7
  REM    1234567890123456789012345678901234567890123456789012345678901234567890123
  REM 01 Speed : F9=00 F8=00 -> bod=9999
  REM 02 DI(DO): F8=00 -> X - 377 - 999
  REM 03 -+-----------+-------------+------------+---------+-----------+---------+
  REM 04 #| IAK       | IRQ         | LCTR       | MCTR    | LSTS      | MSTS    |
  REM 05 #|  F9=00    |  FA=00      |  FB=00     |  FC=00  |  FD=00    |  FE=00  |
  REM 06 -+-----------+-------------+------------+---------+-----------+---------+
  REM 07 0| idiRdy =Y | iReq=Y      | Data  =8   | DTR  =1 | diRdy  =Y | CTSch=Y |
  REM 08 1| idoReq =Y | iTyp=MSTSch |            | RTS  =1 | diRcvr =Y | DSRch=Y |
  REM 09 2| idiErr =Y |      doReq  | Stop  =1.5 | out#1=Y | ptyErr =Y | RIch =Y |
  REM 10 3| iMSTSch=Y | 0    diRdy  | Parity=Y/N | out#2=Y | syncErr=Y | DCDch=Y |
  REM 11 4| 0         | 0    diErr  | pType =E/O | o2i  =Y | diZero =Y | CTS  =1 |
  REM 12 5| 0         | 0           | pFix  =S   | 0       | doReq  =Y | DSR  =1 |
  REM 13 6| 0         | 0           | doZero=Y   | 0       | doEmpt =Y | RI   =1 |
  REM 14 7| 0         | 0           | bodSet=Y   | 0       | timeOut=Y | DCD  =1 |
  REM 15 -+-----------+-------------+------------+---------+-----------+---------+

REM bod
  SELECT CASE F8sp
    CASE &H17
      IF F9sp = &H4 THEN LET bod$ = "110" ELSE LET bod$ = "?"
    CASE &H80
      IF F9sp = &H1 THEN LET bod$ = "300" ELSE LET bod$ = "?"
    CASE &HC0
      IF F9sp = &H0 THEN LET bod$ = "600" ELSE LET bod$ = "?"
    CASE &H60
      IF F9sp = &H0 THEN LET bod$ = "1200" ELSE LET bod$ = "?"
    CASE &H40
      IF F9sp = &H0 THEN LET bod$ = "1800" ELSE LET bod$ = "?"
    CASE &H30
      IF F9sp = &H0 THEN LET bod$ = "2400" ELSE LET bod$ = "?"
    CASE &H20
      IF F9sp = &H0 THEN LET bod$ = "3600" ELSE LET bod$ = "?"
    CASE &H18
      IF F9sp = &H0 THEN LET bod$ = "4800" ELSE LET bod$ = "?"
    CASE &HC
      IF F9sp = &H0 THEN LET bod$ = "9600" ELSE LET bod$ = "?"
    CASE ELSE
      LET bod$ = "?"
  END SELECT

REM IAK
  IF IAK AND &H1 THEN LET idiRdy$ = "idiRdy =Y" ELSE LET idiRdy$ = "idiRdy =N"
  IF IAK AND &H2 THEN LET idoReq$ = "idoReq =Y" ELSE LET idoReq$ = "idoReq =N"
  IF IAK AND &H4 THEN LET idiErr$ = "idiErr =Y" ELSE LET idiErr$ = "idiErr =N"
  IF IAK AND &H8 THEN LET iMSTSch$ = "iMSTSch=Y" ELSE LET iMSTSch$ = "iMSTSch=N"
  IF IAK AND &H10 THEN LET IAK4$ = "1        " ELSE LET IAK4$ = "0        "
  IF IAK AND &H20 THEN LET IAK5$ = "1        " ELSE LET IAK5$ = "0        "
  IF IAK AND &H40 THEN LET IAK6$ = "1        " ELSE LET IAK6$ = "0        "
  IF IAK AND &H80 THEN LET IAK7$ = "1        " ELSE LET IAK7$ = "0        "

REM IRQ
  IF IRQ AND &H1 THEN LET iReq$ = "iReq=Y     " ELSE LET iReq$ = "iReq=N     "
  SELECT CASE IRQ AND &H6
    CASE &H0
      LET iTyp$ = "iTyp=MSTSch"
    CASE &H2
      LET iTyp$ = "iTyp=doReq "
    CASE &H4
      LET iTyp$ = "iTyp=diRdy "
    CASE ELSE
      LET iTyp$ = "iTyp=diErr "
  END SELECT
  IF IRQ AND &H8 THEN LET IRQ3$ = "1          " ELSE LET IRQ3$ = "0          "
  IF IRQ AND &H10 THEN LET IRQ4$ = "1          " ELSE LET IRQ4$ = "0          "
  IF IRQ AND &H20 THEN LET IRQ5$ = "1          " ELSE LET IRQ5$ = "0          "
  IF IRQ AND &H40 THEN LET IRQ6$ = "1          " ELSE LET IRQ6$ = "0          "
  IF IRQ AND &H80 THEN LET IRQ7$ = "1          " ELSE LET IRQ7$ = "0          "

REM LCTR
  SELECT CASE LCTR AND &H3
    CASE &H0
      LET Data$ = "Data  =5  "
    CASE &H1
      LET Data$ = "Data  =6  "
    CASE &H2
      LET Data$ = "Data  =7  "
    CASE ELSE
      LET Data$ = "Data  =8  "
  END SELECT
  IF LCTR AND &H4 THEN
    IF LCTR AND &H3 THEN LET Stop$ = "Stop  =2  " ELSE LET Stop$ = "Stop  =1.5"
  ELSE
    LET Stop$ = "Stop  =1  "
  END IF
  IF LCTR AND &H8 THEN LET Parity$ = "Parity=Y  " ELSE LET Parity$ = "Parity=N  "
  IF LCTR AND &H10 THEN LET pType$ = "pType =E  " ELSE LET pType$ = "pType =O  "
  IF LCTR AND &H20 THEN
    IF LCTR AND &H8 THEN
      IF LCTR AND &H10 THEN LET pFix$ = "pFix  =F1 " ELSE LET pFix$ = "pFix  =F0 "
    ELSE
      LET pFix$ = "pFix  =N  "
    END IF
  ELSE
    LET pFix$ = "pFix  =NF "
  END IF
  IF LCTR AND &H40 THEN LET doZero$ = "doZero=Y  " ELSE LET doZero$ = "doZero=N  "
  IF LCTR AND &H80 THEN LET bodSet$ = "bodSet=On " ELSE LET bodSet$ = "bodSet=Off"

REM MCTR
  IF MCTR AND &H1 THEN LET DTR$ = "DTR  =1" ELSE LET DTR$ = "DTR  =0"
  IF MCTR AND &H2 THEN LET RTS$ = "RTS  =1" ELSE LET RTS$ = "RTS  =0"
  IF MCTR AND &H4 THEN LET out1$ = "out#1=Y" ELSE LET out1$ = "out#1=N"
  IF MCTR AND &H8 THEN LET out2$ = "out#2=Y" ELSE LET out2$ = "out#2=N"
  IF MCTR AND &H10 THEN LET o2i$ = "o2i  =Y" ELSE LET o2i$ = "o2i  =N"
  IF MCTR AND &H20 THEN LET MCTR5$ = "1      " ELSE LET MCTR5$ = "0      "
  IF MCTR AND &H40 THEN LET MCTR6$ = "1      " ELSE LET MCTR6$ = "0      "
  IF MCTR AND &H80 THEN LET MCTR7$ = "1      " ELSE LET MCTR7$ = "0      "
 
REM LSTS
  IF LSTS AND &H1 THEN LET diRdy$ = "diRdy  =Y" ELSE LET diRdy$ = "diRdy  =N"
  IF LSTS AND &H2 THEN LET diRcvr$ = "diRcvr =Y" ELSE LET diRcvr$ = "diRcvr =N"
  IF LSTS AND &H4 THEN LET ptyErr$ = "ptyErr =Y" ELSE LET ptyErr$ = "ptyErr =N"
  IF LSTS AND &H8 THEN LET syncErr$ = "syncErr=Y" ELSE LET syncErr$ = "syncErr=N"
  IF LSTS AND &H10 THEN LET diZero$ = "diZero =Y" ELSE LET diZero$ = "diZero =N"
  IF LSTS AND &H20 THEN LET doReq$ = "doReq  =Y" ELSE LET doReq$ = "doReq  =N"
  IF LSTS AND &H40 THEN LET doEmpt$ = "doEmpt =Y" ELSE LET doEmpt$ = "doEmpt =N"
  IF LSTS AND &H80 THEN LET timeOut$ = "timeOut=Y" ELSE LET timeOut$ = "timeOut=N"

REM MSTS
  IF MSTS AND &H1 THEN LET CTSch$ = "CTSch=Y" ELSE LET CTSch$ = "CTSch=N"
  IF MSTS AND &H2 THEN LET DSRch$ = "DSRch=Y" ELSE LET DSRch$ = "DSRch=N"
  IF MSTS AND &H4 THEN LET RIch$ = "RIch =Y" ELSE LET RIch$ = "RIch =N"
  IF MSTS AND &H8 THEN LET DCDch$ = "DCDch=Y" ELSE LET DCDch$ = "DCDch=N"
  IF MSTS AND &H10 THEN LET CTS$ = "CTS  =1" ELSE LET CTS$ = "CTS  =0"
  IF MSTS AND &H20 THEN LET DSR$ = "DSR  =1" ELSE LET DSR$ = "DSR  =0"
  IF MSTS AND &H40 THEN LET RI$ = "RI   =1" ELSE LET RI$ = "RI   =0"
  IF MSTS AND &H80 THEN LET DCD$ = "DCD  =1" ELSE LET DCD$ = "DCD  =0"

  LOCATE 1, 1

REM 01 Speed : F9=00 F8=00 -> bod=9999
  PRINT "Speed : F9="; HEX$(F9sp); " F8="; HEX$(F8sp); " -> bod="; bod$; SPACE$(20)

REM 02 DI(DO): F8=00 -> X - 377 - 999
  PRINT "DI(DO): F8="; HEX$(DI); " -> ";
  IF DI >= 32 THEN
    PRINT CHR$(DI);
  ELSE
    PRINT ".";
  END IF
  PRINT " - "; OCT$(DI); " - "; DI; SPACE$(20)

REM 03 -+-----------+-------------+------------+---------+-----------+---------+
  PRINT "-+-----------+-------------+------------+---------+-----------+---------+"

REM 04 #| IAK       | IRQ         | LCTR       | MCTR    | LSTS      | MSTS    |
  PRINT "#| IAK       | IRQ         | LCTR       | MCTR    | LSTS      | MSTS    |"

REM 05 #|  F9=00    |  FA=00      |  FB=00     |  FC=00  |  FD=00    |  FE=00  |
  PRINT "#|  F9="; HEX$(IAK);
  PRINT TAB(14); "|  FA="; HEX$(IRQ);
  PRINT TAB(28); "|  FB="; HEX$(LCTR);
  PRINT TAB(41); "|  FC="; HEX$(MCTR);
  PRINT TAB(51); "|  FD="; HEX$(LSTS);
  PRINT TAB(63); "|  FE="; HEX$(MSTS);
  PRINT TAB(73); "|"

REM 06 -+-----------+-------------+------------+---------+-----------+---------+
  PRINT "-+-----------+-------------+------------+---------+-----------+---------+"

REM 07 0| idiRdy =Y | iReq=Y      | Data  =8   | DTR  =1 | diRdy  =Y | CTSch=Y |
  PRINT "0| "; idiRdy$; " | "; iReq$; " | "; Data$; " | "; DTR$; " | "; diRdy$; " | "; CTSch$; " |"

REM 08 1| idoReq =Y | iTyp=MSTSch |            | RTS  =1 | diRcvr =Y | DSRch=Y |
  PRINT "1| "; idoReq$; " | "; iTyp$; " |            | "; RTS$; " | "; diRcvr$; " | "; DSRch$; " |"

REM 09 2| idiErr =Y |             | Stop  =1.5 | out#1=Y | ptyErr =Y | RIch =Y |
  PRINT "2| "; idiErr$; " |             | "; Stop$; " | "; out1$; " | "; ptyErr$; " | "; RIch$; " |"

REM 10 3| iMSTSch=Y | 0           | Parity=Y/N | out#2=Y | syncErr=Y | DCDch=Y |
  PRINT "3| "; iMSTSch$; " | "; IRQ3$; " | "; Parity$; " | "; out2$; " | "; syncErr$; " | "; DCDch$; " |"

REM 11 4| 0         | 0           | pType =E/O | o2i  =Y | diZero =Y | CTS  =1 |
  PRINT "4| "; IAK4$; " | "; IRQ4$; " | "; pType$; " | "; o2i$; " | "; diZero$; " | "; CTS$; " |"

REM 12 5| 0         | 0           | pFix  =S   | 0       | doReq  =Y | DSR  =1 |
  PRINT "5| "; IAK5$; " | "; IRQ5$; " | "; pFix$; " | "; MCTR5$; " | "; doReq$; " | "; DSR$; " |"

REM 13 6| 0         | 0           | doZero=Y   | 0       | doEmpt =Y | RI   =1 |
  PRINT "6| "; IAK6$; " | "; IRQ6$; " | "; doZero$; " | "; MCTR6$; " | "; doEmpt$; " | "; RI$; " |"

REM 14 7| 0         | 0           | bodSet=Y   | 0       | timeOut=Y | DCD  =1 |
  PRINT "7| "; IAK7$; " | "; IRQ7$; " | "; bodSet$; " | "; MCTR7$; " | "; timeOut$; " | "; DCD$; " |"

REM 15 -+-----------+-------------+------------+---------+-----------+---------+
  PRINT "-+-----------+-------------+------------+---------+-----------+---------+"

  RETURN

REM ======================================================================

